//
//  CSSMUtils.h
//  Keychain
//
//  Created by Wade Tregaskis on Thu Mar 13 2003.
//  Copyright (c) 2003 Wade Tregaskis. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Security/Security.h>
#import "UtilitySupport.h"


NSString* CSSMErrorAsString(int error);

NSString* nameOfBERCode(CSSM_BER_TAG tag);
NSString* stringRepresentationOfBEREncodedData(const CSSM_DATA *dat, CSSM_BER_TAG tag);

CSSM_DATE_PTR CSSMDateForCalendarDate(NSCalendarDate *date);
NSCalendarDate* calendarDateForCSSMDate(const CSSM_DATE *date);
NSCalendarDate* calendarDateForTime(const CSSM_X509_TIME *time);

NSString* nameOfKeyBlob(CSSM_KEYBLOB_TYPE type);
NSString* nameOfTypedFormat(CSSM_KEYBLOB_FORMAT format, CSSM_KEYBLOB_TYPE type);
NSString* nameOfAlgorithm(CSSM_ALGORITHMS algo);
NSString* nameOfKeyClass(CSSM_KEYCLASS class);
NSString* nameOfWrapMode(CSSM_ENCRYPT_MODE mode);

NSString* namesOfAttributes(CSSM_KEYATTR_FLAGS attr);
NSString* namesOfUsages(CSSM_KEYUSE use);

NSString* subjectPublicKeyAsString(const CSSM_X509_SUBJECT_PUBLIC_KEY_INFO *key);
NSString* signatureAsString(const CSSM_X509_SIGNATURE *sig);

NSString* x509NameAsString(const CSSM_X509_NAME *name);
NSString* nameOfOIDAlgorithm(const CSSM_OID *oid);

NSString* nameOfDataFormat(CSSM_X509EXT_DATA_FORMAT format);

NSString* x509AlgorithmAsString(const CSSM_X509_ALGORITHM_IDENTIFIER *algo);
NSString* nameOfOIDAttribute(const CSSM_OID *oid);

NSString* nameOfOIDExtension(const CSSM_OID *oid);
NSString* extensionAsString(const CSSM_X509_EXTENSION *ext);
NSString* extensionsAsString(const CSSM_X509_EXTENSIONS *ext);
